﻿using System;
using System.Linq;
using System.Net;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using RestSharp;

namespace Htz.eVisitor.WebApi.Test
{
    [TestClass]
    public class TouristCheckInOut
    {

        [TestMethod]
        public void CheckInCheckOutTourist()
        {
            var cookies = Utility.Login();
            Assert.IsNotNull(cookies);

            var id = Guid.NewGuid();

            //check in
            var response = Utility.ExecuteAction("CheckInTourist", CreateCheckInTourist(id), cookies, Method.POST);

            Assert.AreEqual(string.Empty, response.Content);
            Assert.AreEqual(HttpStatusCode.OK, response.StatusCode);

            //check out
            response = Utility.ExecuteAction("CheckOutTourist", CreateCheckOutTourist(id), cookies, Method.POST);

            Assert.AreEqual(string.Empty, response.Content);
            Assert.AreEqual(HttpStatusCode.OK, response.StatusCode);

            Utility.Logout(cookies);
        }

        [TestMethod]
        public void CheckInAndCancelTourist()
        {
            var cookies = Utility.Login();
            Assert.IsNotNull(cookies);

            var id = Guid.NewGuid();
            var response = Utility.ExecuteAction("CheckInTourist", CreateCheckInTourist(id), cookies, Method.POST);

            Assert.AreEqual(string.Empty, response.Content);
            Assert.AreEqual(HttpStatusCode.OK, response.StatusCode);

            response = Utility.ExecuteAction("CancelTouristCheckIn", new { ID = id }, cookies, Method.POST);

            Assert.AreEqual(string.Empty, response.Content);
            Assert.AreEqual(HttpStatusCode.OK, response.StatusCode);

            Utility.Logout(cookies);
        }

        private static object CreateCheckOutTourist(Guid? id = null)
        {
            var checkOut = DateTime.Now.AddSeconds(-2);

            return new
            {
                ID = id ?? Guid.NewGuid(),
                CheckOutDate = checkOut.ToString("yyyyMMdd"),
                CheckOutTime = checkOut.ToString("HH:mm")
            };
        }

        private static object CreateCheckInTourist(Guid? id = null)
        {
            var stayFrom = DateTime.Now.AddHours(-2);
            var stayUntil = DateTime.Now.AddSeconds(-2);

            return new
            {
                Facility = "0000022",
                ID = id ?? Guid.NewGuid(),
                ArrivalOrganisation = "A",
                Citizenship = "HRV",
                //CityOfBirth = "",
                CityOfResidence = "MILANO",
                CountryOfBirth = "ITA",
                CountryOfResidence = "ITA",
                DateOfBirth = "19970428",
                DocumentNumber = "llasdkjhf235",
                DocumentType = "027",
                Gender = "muški",
                OfferedServiceType = "noćenje",
                ResidenceAddress = "-",
                StayFrom = stayFrom.ToString("yyyyMMdd"),
                TimeStayFrom = stayFrom.ToString("HH:mm"),
                ForeseenStayUntil = stayUntil.ToString("yyyyMMdd"),
                TimeEstimatedStayUntil = stayUntil.ToString("HH:mm"),
                TouristEmail = "",
                TouristMiddleName = "",
                TouristName = "EditTest2",
                TouristSurname = "Checkin edit",
                TouristTelephone = "",
                TTPaymentCategory = "11",
                VisaNumber = "",
                VisaType = "",
                VisaValidityDate = "",
                CheckOutDate = "20160817",
                CheckOutTime = "04:00"

            };
        }
    }
}